#!/usr/local/bin/python
import string,sys

def CHI(resid,chi,delta):
    output="""assign ( resid %3d and name N  ) ( resid %3d and name CA )
       ( resid %3d and name CB ) ( resid %3d and name CG ) 1 %7.2f %7.2f 2""" % ( resid, resid, resid, resid, chi, delta)
    return output

def PHI(resid,phi,delta):
    output="""assign ( resid %3d and name C  ) ( resid %3d and name N  )
       ( resid %3d and name CA ) ( resid %3d and name C  ) 1 %7.2f %7.2f 2""" % ( resid-1, resid, resid, resid, phi, delta)
    return output

def PSI(resid,psi,delta):
    output="""assign ( resid %3d and name N  ) ( resid %3d and name CA )
       ( resid %3d and name C  ) ( resid %3d and name N  ) 1 %7.2f %7.2f 2""" % ( resid, resid, resid, resid+1, psi, delta)
    return output

fi=open(sys.argv[1],'r')
fo=open(sys.argv[2],'w')

for list in fi.readlines():
    item=string.split(list)
    resid=string.atoi(item[0])
    angle1=string.atof(item[3])
    angle2=string.atof(item[4])
    center=(angle1+angle2)/2
    delta=abs(angle2-angle1)/2
    if item[2][:3]=='CHI' : fo.write(CHI(resid,center,delta)+"\n")
    if item[2][:3]=='PHI' : fo.write(PHI(resid,center,delta)+"\n") 
    if item[2][:3]=='PSI' : fo.write(PSI(resid,center,delta)+"\n") 

fi.close()
fo.close()
