/* 2H_pwxcal

  Alex Eletsky, SUNY at Buffalo, March 2008

  Parameters:

        pw = 90 degree excitation pulse on the observe transmitter (C13)
        pwx3 = 90 degree excitation pulse on third decoupler (H2)
        jCD = J(C13-H2) coupling constant (24.2 Hz for C6D6)
        anti = 'y' or 'n' selects in-phase or antiphase triplet
        lkflg = 'y' or 'n' turns lock gating on and off. Default 'y'

1.  Set anti='n' to record an in-phase 13C triplet.
    Calibrate pw and move tof to the center line.
    Measure J(C13-H2) and set jCD to this value.
2.  Set anti='y' pwx3=0. Record a 1D spectrum.
    You should see outer lines antiphase, and the middle line is absent.
    You may further adjust pw to completely suppress the middle line.
3.  Set dof3 and dpwr3 (usually ~40 dB, see the specifications for your
    instrument). Set dm3='nnn'
    Array pwx3 and observe the zero crossing for the outer lines -
    this will be the 90-degree pulse on 2H
4.  Test decoupling by setting anti='n', dm3='nny', dmm3='ccw', dmf3=1/pwx3,
    where pwx3 is the calibrated pulse width. You should see the
    triplet collapse into a singlet

 */
#include <standard.h>

pulsesequence()
{
   double pw;
   double pwx3;
   double jtau;
   double jCD;
   double gt0;
   double gzlvl0;
   double pwZ;

   char   anti[MAXSTR];
   char   lkflg[MAXSTR];

 
   gt0     = getval("gt0");
   gzlvl0  = getval("gzlvl0");

   pw   = getval("pw");
   pwx3  = getval("pwx3");
   jCD  = getval("jCD");

   at   = getval("at");
   getstr("anti", anti);
   getstr("lkflg", lkflg);
   

   jtau = 1.0 / (4.0 * jCD );

   mod4(ct, v1);              /*  v1 = 0 1 2 3 */
   add(one, v1, oph);
   add(two, v1, v2);

/* CHECK VALIDITY OF PARAMETER RANGES */

  if ((anti[A] != 'y') && (anti[A] != 'n'))
  { text_error("Set anti to either 'y' or 'n'!");      psg_abort(1); }

  if ((lkflg[A] != 'y') && (lkflg[A] != 'n'))
  { text_error("Set lkflg to either 'y' or 'n'!");      psg_abort(1); }

  if((dm3[C]=='y') && (anti[A] == 'y'))
  { text_error("H2 decoupling doesn't make sense for antiphase signals!  ");
    psg_abort(1);  }

  if((dm3[C]=='y') && (anti[A] != 'y') && (at > 0.06))
  { text_error("H2 decoupling duty cycle too large, set at to 0.06 or less!  ");
    psg_abort(1); }

  if (anti[A]=='y') {     add(three,oph,oph);}

  pwZ = pw;
  if (pwx3 > pwZ) {    pwZ = pwx3; }

   status(A);
   dec3blank();
   if (lkflg[A] == 'y') {          lk_sample(); }
   hsdelay(d1);
   if (lkflg[A] == 'y') {          lk_hold(); }
   status(B);
   zgradpulse(gzlvl0,gt0);
   delay(2.0e-4);
   rgpulse(pw, v1, rof1, rof2);

   if (anti[A] == 'y') {
      delay(jtau - rof1 - rof2);
      sim4pulse(pw, 0.0, 0.0, pwx3, v2, zero, zero, zero,  rof1, rof2);
   }

   status(C);

   if (dm3[C] == 'y') {
          dec3unblank();
   }
}
