c                                                              c
c   Program converts backbone dihedral angles constraints      c
c    in CAYANA2 format (aco-file) to CNS format (tbl_file)     c
c                                                              c
c    needs  atomtransC.tbl                                     c
c                                                              c
c    Written by Alexander Lemak, (2005)                        c
c                                                              c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

        implicit real*8(a-h,o-z)  
        character*16 fl_aco, fl_dih
	 
        character*1 an1, an2
	character*14 cns1_1, cns1_3
        character*12 cns3_0
        character*10 cns2
        character*3 cns4, angl	
        character*4   AT3, AT4, AT5

        data cns1_1/'assign ( resid'/
        data cns1_3/'        (resid'/, cns2/' and name '/
        data cns3_0/' )   ( resid'/, cns4/' ) '/
        DATA AT3/'C   '/, AT4/'N   '/, AT5/'CA  '/

cc
        call GETARG(1,fl_aco)
        open(10, file=fl_aco)
        call GETARG(2,fl_dih)
        open(11, file=fl_dih)

         rewind 10

	 ndih = 0
         do  i=1,1000

	    read(10,100,err=1,end=1) ir, angl, fi1, fi2

                delt = DABS( fi2 - fi1 )              
                fi   = fi1 + 0.5D0*delt
                dfi  = 0.5D0*delt

               ndih = ndih + 1
	    
               ICON = 1
               ir1 = ir - 1
               ir2 = ir
               ir3 = ir + 1	       
               NEX = 2 
	       
	    IF( angl .eq. 'PHI' ) THEN 
	    
              WRITE(11,202) cns1_1, ir1,cns2, AT3, cns3_0, 
     +                   ir2,cns2, AT4,cns4
 
              WRITE(11,203) cns1_3, ir2,cns2, AT5, cns3_0, 
     +              ir2,cns2, AT3,cns4,ICON,FI,DFI,NEX

           ENDIF
	    
	    IF( angl .eq. 'PSI' ) THEN
	     	    
              WRITE(11,202) cns1_1, ir2,cns2, AT4, cns3_0, 
     +                   ir2,cns2, AT5,cns4
 
              WRITE(11,203) cns1_3, ir2,cns2, AT3, cns3_0, 
     +              ir3,cns2, AT4,cns4,ICON,FI,DFI,NEX
	    
            ENDIF

         enddo
 1       print *,'number of restraints ', ndih
 
 
 100     format(I4,7X,A3,2X,2F8.1)
 202    FORMAT(A14,i5,A10,A4,A12,i5,A10,A4,A3)
 203    FORMAT(A14,i5,A10,A4,A12,i5,A10,A4,A3,I2,F8.2,F8.2,I2)
  
        STOP
	END                   
