c                                                                c
c   Program converts distance (noe or hbond) constraints         c 
c    in CAYANA2 format (upl-file) to CNS format (tbl_file)       c
c                                                                c
c    needs  atomtransC.tbl                                       c
c                                                                c
c    Written by Alexander Lemak, (2005)                          c
c                                                                c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

        implicit real*8(a-h,o-z)

        PARAMETER (NPM=10000) 

        character*4 at1,at2,bt1,bt2
        character*1  an1, an2, an3, an4  

        character*20 fl_sqn, fl_dya, fl_cns 
        character*14 cns0_1
        character*12 cns0_2
        character*10 cns2
        character*3  cns4, seq(200), resnm, resnm1, resnm2  
	  
	 character*3 restbl(400)
	 character*4 atmtbl(5,400)	 
	 	
	 COMMON /tbl/ restbl, atmtbl, ntbl	 

        data cns0_1/'assign ( resid'/,cns0_2/' )   ( resid'/
        data cns2/' and name '/,  cns4/' ) '/
	
c
          iconv = 4   !  xplor
c
        call GETARG(1,fl_dya)  !file with cyana2 constrainta
        open(11, file=fl_dya)
	
        call GETARG(2,fl_cns)  !file with CNS constraints
        open(12, file=fl_cns)
c
          ntbl = 375
c
          itbl1 = 5
	  
	  itbl2 = 3	  
	  
c
          open(33,file='atomtransC.tbl')
	  do i=1,ntbl
	  read(33,'(A3,2X,4(A4,1X),A4)') 
     +	           restbl(i),(atmtbl(kk,i),kk=1,5)

          enddo	
c

        rewind 11
	npk = 0
	do i=1,6000
	
C	   read(11,200,err=2,end=2) id1,resnm1,at1,id2,resnm2,at2,di 
	   read(11,*,err=2,end=2) id1,resnm1,at1,id2,resnm2,at2,di 	   
                      
c  cyana to xplor names                             


	    call atom_trans(itbl1,at1,itbl2,bt1,resnm1)
	    call atom_trans(itbl1,at2,itbl2,bt2,resnm2)	

c vyravnyvt' sprava


           if( bt1 .eq. 'O   ' .OR. bt2 .eq. 'O  ' ) then
	        dp = 0.3
		dx = di
		dm = 0.1*di
	   else
                call dist2tbl( iconv,di,dx,dm,dp )           
           endif 
c         

           write(12,108) cns0_1, id1,cns2, bt1, cns0_2, 
     +                  id2,cns2, bt2,cns4, dx, dm, dp 
     	    
	        	
	   npk = npk + 1
	  
	enddo
2        print *,'number of restraints ', npk	


 200    format(I3,1X,A3,2X,A4,2X,I3,1X,A3,2X,A4,3X,F5.2)
  108    format(A14,I5,A10,A4,A12,I5,A10,A4,A3,3F6.2)
  
c
        STOP
	END  
c----------------------------------------------------------------------
c
        SUBROUTINE  atom_trans(itb1,atm1,itb2,atm2,resnm)
c
c  itb =  1   -  BMRB
c         2   -  PDB
c         3   -  CNS
c         4   -  XPLOR  
c         5   -  CAYANA2
	
	character*4 atm1, atm2 
	character*3 resnm
	character*3 restbl(400)
        character*4 atmtbl(5,400)	 
	
        COMMON /tbl/ restbl, atmtbl, ntbl
c
c atmom names  vyrovn sprava
c
c
c                                     ! translation
	   ktbl = 0
	   do  k=1,ntbl
             if( ( restbl(k) .eq. resnm ) .AND.
     +           ( atmtbl(itb1,k) .eq. atm1 ) ) ktbl = k	        
           enddo
	   if( ktbl .eq. 0 ) then
	     print *,'no translation for ',resnm,' ',atm1,'  ',itb1
	   else
	     atm2 = atmtbl(itb2,ktbl)
	   endif
c
         RETURN
	 END 

c======================================================================================
c
       SUBROUTINE dist2tbl( iconv,d,dx,dm,dp ) 
       
       implicit real*8(a-h,o-z) 
c
c 0                                            ! loose	
       IF( iconv .eq. 0 ) THEN
                        
           dx = 4.0
           dp = 1.5
           dm = 2.2
	   
        ENDIF	 
c             
c
c 1                                             ! protein Y
       IF( iconv .eq. 1 ) THEN
       
          if( d .gt. 3.5D0 )  then
               dx = 4.0
               dp = 2.0
               dm = 2.2
           endif
           if( d .gt. 2.7D0 .AND. d .le. 3.5D0 ) then
               dx = 3.0
               dp = 1.5
               dm = 1.2
           endif
           if( d .le. 2.7D0 )  then
               dx = 2.0
               dp = 1.8
               dm = 0.2
           endif
	   
        ENDIF
c 2	                                        ! J-W
       IF( iconv .eq. 2 ) THEN
                        
           if( d .gt. 3.5D0 )  then
               dx = 4.0
               dp = 1.0
               dm = 2.2
           endif
           if( d .gt. 2.8D0 .AND. d .le. 3.5D0 ) then
               dx = 3.0
               dp = 0.5
               dm = 1.2
           endif
           if( d .le. 2.8D0 )  then
               dx = 2.0
               dp = 0.8
               dm = 0.2
           endif
	    
	   
        ENDIF	 
c
c 4                                            	
       IF( iconv .eq. 3 ) THEN
                        
           dx = 0.5*( d + 1.8 )
           dp = 0.5*( d - 1.8 )
           dm = dp
	   
        ENDIF
c
       IF( iconv .eq. 4 ) THEN
                        
           if( d .gt. 5.0D0 )  then
               dx = 4.0
               dp = 2.0
               dm = 2.2
           endif
           if( d .gt. 3.5D0 .AND. d .le. 5.0 )  then
               dx = 4.0
               dp = 1.0
               dm = 2.2
           endif	   
           if( d .gt. 2.7D0 .AND. d .le. 3.5D0 ) then
               dx = 3.0
               dp = 0.5
               dm = 1.2
           endif
           if( d .le. 2.7D0 )  then
               dx = 2.0
               dp = 0.7
               dm = 0.2
           endif
	    
	   
        ENDIF			 
c
       IF( iconv .eq. 5 ) THEN
                        
           dx = d
           dp = 0.12 * d * d
           dm = d - 1.8 
	   
        ENDIF
c
       return
       end
