#!/usr/bin/python
"""
Script for running of H2O refinement
2003.3.08 Jung, Jin-Won.
Version 1.0.2
"""

import sys,string,re,os

#Change below path
#PATH="/users/bwu/h2orefine"
PATH="/soft/WaterRefinement_cns"

def usage():
    print """
Usage : h2orefine.py -p prefix -s seqfile -u uplfile -c corfile [-h hbondfile] [-d acofile] \n""" 


def upl2tbl(original, converted):
    flag=0
    fi=open(original,'r')
    fo=open(converted,'w')

    for line in fi.readlines():
        item=string.split(line)
        if item[0][0]=='#' : continue
        if len(item)<7 : continue
        if item[2]=='QG1' : item[2]='HG1*'
        if item[2]=='QG2' : item[2]='HG2*'
        if item[5]=='QG1' : item[5]='HG1*'
        if item[5]=='QG2' : item[5]='HG2*'
        if item[2]=='QQD' : 
            item[2]='HD*'
            flag=1 
        if item[5]=='QQD' :
            item[5]='HD*'
            flag=1
        if item[2][0]=='Q' :
            item[2]='H'+item[2][1:]+'*'
            flag=1
        if item[5][0]=='Q' :
            item[5]='H'+item[5][1:]+'*'
            flag=1
        if item[2]=='QQG' : 
            item[2]='HG*'
            flag=1 
        if item[5]=='QQG' :
            item[5]='HG*'
            flag=1        
        upl=string.atof(item[6])
        if upl > 3.5 :
            if flag == 1 : range = "4.0 2.2 2.0"
            else :
                range = "4.0 2.2 1.0"
                flag=0
        if upl > 2.8 and upl <=3.5 :
            if flag == 1 : range = "3.0 1.2 1.5"
            else :
                range = "3.0 1.2 0.5"
                flag=0
        if upl <= 2.8 :
            if flag == 1 : range = "2.0 0.2 1.8"
            else :
                range = "2.0 0.2 0.8"
                flag=0
        if upl <= 2.3 and (item[2]=='O' or item[5]=='O') : range = "2.0 0.2 0.3"
        if upl > 2.3 and (item[2]=='O' or item[5]=='O') : range = "3.0 0.3 0.3" 
        fo.write("assign ( resid %4s and name %4s ) ( resid %4s and name %4s ) %s\n" 
                 % ( item[0], item[2], item[3], item[5], range))

    fi.close()
    fo.close()
    return

def aco2cns(aco,dihe):
    def CHI1(resid,chi,delta):
        output="""assign ( resid %3d and name N  ) ( resid %3d and name CA )
           ( resid %3d and name CB ) ( resid %3d and name CG ) 1 %7.2f %7.2f 2""" % ( resid, resid, resid, resid, chi, delta)
        return output

    def PHI(resid,phi,delta):
        output="""assign ( resid %3d and name C  ) ( resid %3d and name N  )
           ( resid %3d and name CA ) ( resid %3d and name C  ) 1 %7.2f %7.2f 2""" % ( resid-1, resid, resid, resid, phi, delta)
        return output

    def PSI(resid,psi,delta):
        output="""assign ( resid %3d and name N  ) ( resid %3d and name CA )
           ( resid %3d and name C  ) ( resid %3d and name N  ) 1 %7.2f %7.2f 2""" % ( resid, resid, resid, resid+1, psi, delta)
        return output

    fi=open(aco,'r')
    fo=open(dihe,'w')

    for list in fi.readlines():
        item=string.split(list)
        if item[0][0]=='#' : continue
        if len(item)<5 : continue
        resid=string.atoi(item[0])
        angle1=string.atof(item[3])
        angle2=string.atof(item[4])
        center=(angle1+angle2)/2
        delta=abs(angle2-angle1)/2
        if item[2][:4]=='CHI1' : fo.write(CHI1(resid,center,delta)+"\n")
        if item[2][:3]=='PHI' : fo.write(PHI(resid,center,delta)+"\n") 
        if item[2][:3]=='PSI' : fo.write(PSI(resid,center,delta)+"\n") 

    fi.close()
    fo.close()
    return

def pdbsplit(pdb,prefix):
    count=0
    fi=open(pdb,'r')
    for list in fi.readlines():
        if list[:5]=='MODEL' :
           number=string.atoi(string.split(list)[1])
           outputfilename="%s_%d.pdb" % (prefix, number )
           fo=open(outputfilename,'w')
        if list[:3]=='TER' :
           fo.write("END\n")
           fo.close()
           count=count+1
        if list[:4]=='ATOM' : 
            fo.write(list[:20]+' '+list[21:])
        if list[:5]=='REMARK' :
            fo.write(list)
    return count

def atomtls(prefix):
    count=1
    while 1 :
        try :
           fi=open("%s_%d.pdb" % ( prefix, count ) ,'r+')
           pdb=fi.readlines() 
           fi.seek(0)
           for list in pdb:
               if list[:4]=='ATOM' : 
                 if string.split(list)[2]=='H' : name='HN  '
                 elif list[12]==' ' or ( list[12]>='0' and list[12]<='9') :
                    name=list[12:16]
                    if name[-1]==' ' : name=name[1:-1]+name[0]+' ' 
                    else : name=name[1:]+name[0]
                 fi.write(list[:12]+name+list[16:])
               else : fi.write(list) 
           fi.close()
        except :
            return
        count=count+1
    return

###MAIN PART

if not os.access(PATH,os.R_OK) :
    print "Change PATH in this script for your system\n"
    os._exit(0)
    
a=len(sys.argv)

if a < 7 :
    usage()
    os._exit(0)

count=1
hbflag=0
diheflag=0
while count<a :
    if sys.argv[count]=='-p' :
        count=count+1
        prefix=sys.argv[count]
    if sys.argv[count]=='-s' :
        count=count+1
        seq_file=sys.argv[count]
        if not os.access(seq_file,os.R_OK) :
            print "%s is not found:" % seq_file
            os._exit(0)
    if sys.argv[count]=='-u' :
        count=count+1
        upl_file=sys.argv[count]
        if not os.access(upl_file,os.R_OK) :
            print "%s is not found" % upl_file
            os._exit(0)        
    if sys.argv[count]=='-h' :
        count=count+1
        hbond_file=sys.argv[count]
        hbflag=1
        if not os.access(hbond_file,os.R_OK) :
            print "%s is not found" % hbond_file
            os._exit(0)
    if sys.argv[count]=='-d' :
        count=count+1
        dihe_file=sys.argv[count]
        diheflag=1
        if not os.access(dihe_file,os.R_OK) :
            print "%s is not found" % dihe_file
            os._exit(0)
    if sys.argv[count]=='-c' :
        count=count+1
        cor_file=sys.argv[count]
        if not os.access(cor_file,os.R_OK) :
            print "%s is not found" % cor_file
            os._exit(0)
    count=count+1

#Part 1: Translate the atom name to CNS

pdbfile="%s_all.pdb" % prefix
translated_upl_file="%s_tmp.upl" % prefix
cyanascript="""cyanalib
read seq %s
read cor %s
read upl %s
translate xplor
write pdb %s all
write upl %s
quit
""" % ( seq_file, cor_file, upl_file, pdbfile, translated_upl_file)

fo=open("trans.cya",'w')
fo.write(cyanascript)
fo.close()
os.system("/users/arrowdata/software/cyana-1.0.5/cyana trans > /dev/null")

while not os.access(translated_upl_file,os.R_OK) :
   pass

#Part 2: Split PDB file and change atom name
try:
    os.mkdir("PDB")
except:
    pass
tmppdb="PDB/%scy" % prefix
count=pdbsplit( pdbfile,tmppdb )
count="%d" % count
atomtls( tmppdb )

#Part 3: Change file for CNS
mtffile="%s.mtf" % prefix
noetbl="%s_noe.tbl" % prefix
hbondtbl="%s_hbond.tbl" % prefix
dihetbl="%s_dihe.tbl" % prefix
NAME="PDB/%s" % prefix

upl2tbl(translated_upl_file, noetbl )
if hbflag==1 : upl2tbl(hbond_file, hbondtbl )
if diheflag==1 : aco2cns(dihe_file, dihetbl )

#Part 4 : Generate Scripts

file1=open("%s/generate.inp" % PATH ,'r' )
file2=open("%s/rebuild.inp" % PATH , 'r' )
file3=open("%s/re_h2o.inp" % PATH , 'r' )

generate=file1.read()
rebuild=file2.read()
refine=file3.read()
file1.close()
file2.close()
file3.close()


generate=re.sub("PATH53",PATH,generate)
rebuild=re.sub("PATH53",PATH,rebuild)
refine=re.sub("PATH53",PATH,refine)
generate=re.sub("MTFFILE",mtffile,generate)
rebuild=re.sub("MTFFILE",mtffile,rebuild)
refine=re.sub("MTFFILE",mtffile,refine)
generate=re.sub("TMPPDB",tmppdb,generate)
rebuild=re.sub("TMPPDB",tmppdb,rebuild)
rebuild=re.sub("NAME",NAME,rebuild)
refine=re.sub("NAME",NAME,refine)
rebuild=re.sub("ENDNUMBER",count,rebuild)
refine=re.sub("ENDNUMBER",count,refine)
refine=re.sub("NOETABLE",noetbl,refine)

if hbflag==1 : 
   refine=re.sub("HBONDTABLE",hbondtbl,refine)
else :
   refine=re.sub("@@HBONDTABLE",' ',refine)

if diheflag==1 :
   refine=re.sub("DIHETABLE",dihetbl,refine)
else :
   refine=re.sub("@@DIHETABLE", ' ', refine)

file1=open("generate.inp",'w')
file2=open("rebuild.inp",'w')
file3=open("re_h2o.inp",'w')

file1.write(generate)
file2.write(rebuild)
file3.write(refine)
file1.close()
file2.close()
file3.close()

print "CNS is running : generate.inp"
os.system("cns < generate.inp ")
print "CNS is running : rebuilding of PDB"
os.system("cns < rebuild.inp ")
print "CNS is running : refinement"
os.system("cns < re_h2o.inp ")
